<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('employment_history', function (Blueprint $table) {
            $table->unsignedBigInteger('Employment_id')->autoIncrement();
            $table->unsignedBigInteger('User_id');
            $table->string('Company_name', 255);
            $table->string('Position', 255);
            $table->date('Start_date');
            $table->date('End_date')->nullable();
            $table->boolean('Currently_working')->default(0);
            $table->text('Description')->nullable();
            $table->timestamp('Created_at')->default(DB::raw('CURRENT_TIMESTAMP'));
            $table->timestamp('Updated_at')->default(DB::raw('CURRENT_TIMESTAMP'))->onUpdate(DB::raw('CURRENT_TIMESTAMP'));
            $table->foreign('User_id', 'employment_history_user_id_foreign')->references('User_id')->on('users')->onDelete('cascade');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('employment_history');
    }
};
